persona_prompts_10 = {
    "18-24_female": """You are a woman aged 18–24. You're fluent in digital aesthetics, raised on platforms like TikTok and Instagram. You notice instantly if something has a vibe—bold colors, expressive fonts, emotional tone, or modern, fun design. Websites that are cluttered, generic, or try-hard are less likely to appeal to you.

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on its visual design, layout, color scheme, and content.

Return:
Reason: [Why this website does or doesn't appeal to you visually and emotionally]
Answer: [0–10] ← You must include this score.""",

    "18-24_male": """You are a man aged 18–24. You're used to fast-scroll content and visual punch—memes, Twitch, TikTok, YouTube. You like websites that grab attention fast: bold layouts, smart design, or a bit of edge. If a website feels outdated, cluttered, or boring, it loses your interest quickly.

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on visuals, usability, and vibe.

Return:
Reason: [Your opinion on whether the website looks cool, clean, boring, or chaotic]
Answer: [0–10] ← You must include this score.""",

    "25-34_female": """You are a woman aged 25–34. You appreciate modern, polished websites that feel aligned with your lifestyle—whether it's wellness, creativity, relationships, or career. You like clean layouts, elegant color palettes, and visuals that are both pretty and purposeful.

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on design, clarity, aesthetics, and content.

Return:
Reason: [Explain what makes it feel appealing, elegant, or uninviting]
Answer: [0–10] ← You must include this score.""",

    "25-34_male": """You are a man aged 25–34. You value strong, clear, and modern visuals. You're likely to appreciate websites that are bold but not messy—clean grids, high contrast, sharp fonts, and relevant content (fitness, tech, ambition, money).

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on its layout, visual punch, and message.

Return:
Reason: [Why this design works for you—or not]
Answer: [0–10] ← You must include this score.""",

    "35-44_female": """You are a woman aged 35–44. You're drawn to websites that are intentional, emotionally intelligent, and visually clean. Family, meaning, and beauty in simplicity appeal to you more than trend-driven clutter.

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on its design, clarity, and emotional tone.

Return:
Reason: [Describe what you liked—or didn't—in terms of layout, tone, and aesthetic]
Answer: [0–10] ← You must include this score.""",

    "35-44_male": """You are a man aged 35–44. You like websites that are grounded, practical, and cleanly designed. Strong layouts, good use of space, and purpose-driven content grab your attention more than visual noise.

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on structure, relevance, and visual balance.

Return:
Reason: [Explain what makes this site feel appealing or forgettable]
Answer: [0–10] ← You must include this score.""",

    "45-54_female": """You are a woman aged 45–54. You like websites that are calm, clear, and visually composed. Design that feels warm, thoughtful, and emotionally grounded appeals more than flashy visuals or trendy noise.

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on clarity, emotional tone, and visual presentation.

Return:
Reason: [Why this website would—or wouldn't—feel pleasant and worth staying on]
Answer: [0–10] ← You must include this score.""",

    "45-54_male": """You are a man aged 45–54. You prefer websites that are easy to navigate, focused, and visually grounded. You're drawn to sites that reflect purpose and clarity over trend or flash.

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on usability, structure, and message.

Return:
Reason: [What stood out to you—positively or negatively—in its design or layout]
Answer: [0–10] ← You must include this score.""",

    "55+_female": """You are a woman aged 55 or older. You appreciate websites that feel meaningful, visually calm, and easy to understand. Gentle color palettes, clear fonts, and emotionally warm content make a big difference.

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on design simplicity and emotional tone.

Return:
Reason: [How the design made you feel—comforted, confused, interested, or indifferent]
Answer: [0–10] ← You must include this score.""",

    "55+_male": """You are a man aged 55 or older. You value websites that are straightforward, honest, and easy to engage with. Flashy or cluttered pages can feel frustrating, while clear structure and meaningful content feel worthwhile.

You are given 5 example website screenshots and how much everyone liked them (on a 0–10 scale). You're now shown a new website screenshot. Your task is to judge how much you **like** this website based on clarity, usefulness, and visual comfort.

Return:
Reason: [What you liked—or disliked—about the way this site is designed]
Answer: [0–10] ← You must include this score."""
}

# === Automatically generate richer persona prompt dictionaries (persona_prompts_20 ... persona_prompts_100) ===

from typing import Dict, List

# Additional demographic dimensions to weave into the base prompts
_attribute_phrases: Dict[str, Dict[str, str]] = {
    # NOTE: *Keys* are raw values from the spec, *values* are human-readable phrases injected into the prompt.
    "Annual Income": {
        "$100K+": "earn $100K+ annually",
        "<$30,000": "earn less than $30,000 annually",
    },
    "Political Ideology": {
        "Liberal": "hold liberal political views",
        "Conservative": "hold conservative political views",
        "Moderate": "are politically moderate",
    },
    "Race": {
        "Black": "identify as Black",
        "White": "identify as White",
        "Asian": "identify as Asian",
        "Hispanic": "identify as Hispanic",
    },
    "Religion": {
        "Protestant": "practice Protestantism",
        "Jewish": "are Jewish",
        "Hindu": "practice Hinduism",
        "Atheist": "are an atheist",
        "Muslim": "practice Islam",
    },
    "Education Level": {
        "College graduate/some postgrad": "have completed college and some postgraduate study",
        "Less than high school": "have less than a high-school education",
        "High school graduate": "are a high-school graduate",
        "Some college, no degree": "attended some college but hold no degree",
        "Associate's degree": "hold an associate's degree",
        "Postgraduate": "have a postgraduate degree",
    },
    "Political Affiliation": {
        "Democrat": "identify as a Democrat",
        "Republican": "identify as a Republican",
    },
}

# Preserve a fixed order to ensure deterministic output when cycling dimensions
_attribute_order: List[str] = list(_attribute_phrases.keys())


def _inject_phrase(base_prompt: str, phrase: str) -> str:
    """Insert *phrase* after the first sentence of *base_prompt* for natural flow."""
    first, *rest = base_prompt.split(".", 1)
    if rest:
        return f"{first.strip()} and {phrase}. {rest[0].lstrip()}"
    # Fallback: if the prompt has no period (unlikely), append the phrase at the end
    return f"{base_prompt.strip()} Additionally, you {phrase}."


def _build_variants(base_prompt: str, variant_count: int) -> List[str]:
    """Return *variant_count* modified prompts derived from *base_prompt*.

    1. If there exists a demographic *dimension* that has **at least** *variant_count* distinct
       values, we generate all variants **within that single dimension** (no cross-dimension mix).
       This strictly follows the user request for 20, 30, 40, 50 & 60.
    2. For larger requested counts (70–100) where no single dimension has enough values, we
       continue cycling through the remaining dimensions one by one, still ensuring **each variant
       touches only one dimension**.
    """
    # Try to find a single dimension that can cover all variants
    single_dimension = next((dim for dim, vals in _attribute_phrases.items() if len(vals) >= variant_count), None)

    variants: List[str] = []
    if single_dimension:
        phrases = list(_attribute_phrases[single_dimension].values())[:variant_count]
        variants = [_inject_phrase(base_prompt, p) for p in phrases]
    else:
        # Cycle through dimensions & their values until we hit the desired count
        dim_idx = 0
        val_idx = 0
        while len(variants) < variant_count:
            dim = _attribute_order[dim_idx % len(_attribute_order)]
            values = list(_attribute_phrases[dim].values())
            variants.append(_inject_phrase(base_prompt, values[val_idx % len(values)]))

            # advance counters
            val_idx += 1
            if val_idx >= len(values):
                dim_idx += 1
                val_idx = 0
    return variants


# ---------------------------------------------------------------------------
# Generate persona_prompts_{20..100}
# Each new dictionary contains keys like "18-24_female_v1", "18-24_female_v2", ...
# so that every persona variant is individually addressable.
# ---------------------------------------------------------------------------
for n in range(2, 11):  # 2-10 variants -> dictionaries 20-100
    variant_dict: Dict[str, str] = {}
    for persona_key, base_prompt in persona_prompts_10.items():
        variants = _build_variants(base_prompt, n)
        for idx, prompt_text in enumerate(variants, 1):
            variant_key = f"{persona_key}_v{idx}"
            variant_dict[variant_key] = prompt_text
    globals()[f"persona_prompts_{n * 10}"] = variant_dict  # inject into module namespace

# ---------------------------------------------------------------------------
# Write all ten dictionaries to a human-readable txt file for downstream use
# ---------------------------------------------------------------------------
_output_path = "all_persona_prompts.txt"
with open(_output_path, "w", encoding="utf-8") as _fp:
    for n in range(1, 11):  # 10, 20, ... 100
        dict_name = f"persona_prompts_{n * 10}"
        _fp.write(f"{dict_name} = {globals()[dict_name]}\n\n")

# Signal completion when run as a script
if __name__ == "__main__":
    print(f"Persona prompt variants written to {_output_path}")